﻿using Microscopic_Traffic_Simulator.ViewModels;
using System;
using System.Windows;

namespace Microscopic_Traffic_Simulator.Views.MainWindowView
{
    /// <summary>
    /// GUIInteractions logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        /// <summary>
        /// Initialization of main window.
        /// </summary>
        public MainWindow()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Handling closing the application by asking potentially whether to save the current
        /// topology.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Unused event args.</param>
        private void mainWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            e.Cancel = !(DataContext as MainViewModel).CanBeClosed();        
        }

        /// <summary>
        /// Connect event receivers to commands' CommandExecuted event handlers to perform
        /// post command UI operations.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Unused event args.</param>
        private void mainWindow_Loaded(object sender, RoutedEventArgs e)
        {
            MainViewModel mainViewModel = DataContext as MainViewModel;
            (mainViewModel.NewGeometricTopologyCommand as ObservableRelayCommand)
                .CommandExecuted += MainWindow_NewOpenCommandExecuted;
            (mainViewModel.OpenGeometricTopologyCommand as ObservableRelayCommand)
                .CommandExecuted += MainWindow_NewOpenCommandExecuted;
            mainViewModel.AnotherTopologyInitializedOrOpened += mainViewModel_AnotherTopologyInitializedOrOpened;            
        }

        /// <summary>
        /// Event handler for events of initialization or opening of another topology.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Unused event args.</param>
        void mainViewModel_AnotherTopologyInitializedOrOpened(object sender, EventArgs e)
        {
            // TODO isnt it redundant?
            mainWindow.canvasUserControl.RoadPreviewer.ClearPreviewOfBuildingOfAnyRoads();
            canvasUserControl.SimulationTrafficRenderer.DetachEventHandlerFromCellularTopology();            
        }

        /// <summary>
        /// Event receiver for rendering topology right after the new geometric topology was 
        /// initialized or existing topology was opened.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Unused event args.</param>
        void MainWindow_NewOpenCommandExecuted(object sender, EventArgs e)
        {
            canvasUserControl.TopologyRenderer.GeometricTopology =
                (canvasUserControl.DataContext as CanvasViewModel).GeometricTopology;
            canvasUserControl.TopologyRenderer.RenderTopology();
            mainWindow.canvasUserControl.RoadPreviewer.ClearPreviewOfBuildingOfAnyRoads();
        }
    }
}
